<?php

namespace backend\modules\gas_liquid\controllers;

use backend\modules\gas_liquid\models\logic\AgentLogic;
use backend\modules\gas_liquid\models\logic\AgentUserLogic;
use backend\modules\gas_liquid\models\form\MessageForm;
use backend\modules\user\models\RoleLogic;
use backend\modules\user\models\UserLogic;
use Yii;
use yii\filters\AccessControl;


/**
 * ReportController manages the production and display of reports .
 */
class AjaxController extends \common\controllers\BaseController
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['change-user','change-message','show-message-form'],
                        'roles' => [RoleLogic::PERMISSION_CREATE_MESSAGES],
                    ],

                ],
            ],

        ];
    }

    /**
     * change user list of a agent
     * @return string
     */
    public function actionShowMessageForm()
    {
        $result=false;
        $userId=false;
        if ($get = Yii::$app->request->get()) {
            if (isset($get['agentId'])) $agentId = $get['agentId'];
            if($agent=AgentLogic::find()->where(['id'=>$agentId])->notDeleted()->one())
                $result['agent']=$agent->name;
            $agentUser=New AgentUserLogic();
            $result['user']='';
            if($userList=$agentUser->get_users_of_agent($agentId)) {
                foreach ($userList as $user) {
                    $result['user'] .= "<option value='" . $user['id'] . "'> " . $user['name'] . " </option>";
                    if (!$userId) {
                        if (isset($user['mobile']) && $user['mobile']) {
                            $result['phone'] = substr($user['mobile'], 1, strlen($user['mobile']) - 1);
                            $userId = $user['id'];
                        }
                    }
                }
                if($userId) {
                    $messageForm = new MessageForm();
                    $messageForm->message_type = MessageForm::SendUsernamePassword;
                    $messageForm->agent = $agentId;
                    $messageForm->user = $userId;
                    $message = $messageForm->getMessage();
                    $result['message'] = $message;
                }
            }
        }
        return $this->sendAjaxResponse($result);
    }
    /**
     * change phone number field when change user
     * @return int
     */
    public function actionChangeUser()
    {
        $result=false;
        if ($get = Yii::$app->request->get()) {
            if (isset($get['userId'])) $userId = $get['userId'];
            if (isset($get['messageType'])) {
                $messageForm=New MessageForm();
                $messageForm->message_type = $get['messageType'];
                if($messageForm->message_type==MessageForm::SendUsernamePassword){
                    if (isset($get['agentId'])) $messageForm->agent = $get['agentId'];
                    $message=$messageForm->getMessage();
                    $result['message']=$message;
                }
            }
        }
        if($user=UserLogic::find()->where(['id'=>$userId])->notDeleted()->one())
            if($user->mobile)
                    $result['phone']=substr($user->mobile,1,strlen($user->mobile)-1);
        return $this->sendAjaxResponse($result);
    }
    /**
     * change message field when change message type
     * @return string
     */
    public function actionChangeMessage()
    {
        $result=false;
        $messageForm=New MessageForm();
        if ($get = Yii::$app->request->get()) {
            if (isset($get['userId'])) $messageForm->user = $get['userId'];
            if (isset($get['agentId'])) $messageForm->agent = $get['agentId'];
            if (isset($get['messageType'])) $messageForm->message_type = $get['messageType'];
        }
        $message=$messageForm->getMessage();
        $result['message']=$message;
        return $this->sendAjaxResponse($result);
    }
}