<?php

namespace backend\modules\gas_liquid\controllers;

use backend\modules\gas_liquid\models\logic\AgentUserLogic;
use backend\modules\user\models\RoleLogic;
use backend\modules\user\models\UserLogic;
use Yii;
use backend\modules\gas_liquid\models\activeRecord\AgentUser;
use backend\modules\gas_liquid\models\search\AgentUserSearch;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * AgentUserController implements the CRUD actions for AgentUser model.
 */
class AgentUserController extends \common\controllers\BaseController
{
    public $layout='gasLiquid';
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['delete-user-ajax','create-user-ajax','insert_user_block'],
                        'roles' => [RoleLogic::PERMISSION_UPDATE_FACTORY],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all AgentUser models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new AgentUserSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single AgentUser model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new AgentUser model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new AgentUser();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing AgentUser model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing AgentUser model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the AgentUser model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return AgentUser the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = AgentUser::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionCreateUserAjax()
    {
        $model = new UserLogic();
        //$model->setScenario('create');
        $result['msg']= Yii::t('app', 'Error occurred during user creating');
        $result['result']=0;
        $post=Yii::$app->request->post();
        if (isset($post['agentId']) && $post['agentId']){
            $agentId=$post['agentId'];
        }
        foreach ($post['data'] as $index=>$content){
            $fieldName=substr($content['name'],strpos($content['name'],'[')+1 ,strpos($content['name'],']')-strpos($content['name'],'[')-1);
            $data['UserLogic'][$fieldName]=$content['value'];
        }
        if(isset($data)) {
            if ($model->load($data)) {
                $model->setPassword($model->password);
                $model->generatePasswordResetToken();
                $model->generateAuthKey();

                if ($model->email == '') $model->email = null;
                if ($model->save()) {
                    $auth = Yii::$app->authManager;
                    $authRole = $auth->getRole($model->role);
                    $auth->assign($authRole, $model->id);
                    //-------------------------Create Agent User-------------------------------------------------
                    $modelAgentUser=New AgentUserLogic();
                    $modelAgentUser->user_id=$model->id;
                    $modelAgentUser->agent_id=$agentId;
                    if($modelAgentUser->save()) {
                        $result['result']=1;
                        $result['msg'] = Yii::t('app', 'User has been successfully submitted');
                        $result['data']='<div class="row">
                                                <div class="col-6 pl-0  parent_of_dropdown">
                                                    <span class="form-control users_list">'.$modelAgentUser->userId->name.'</span>
                                                </div>
                                                <div class="col-2 parent_of_btn "><span id="'.$modelAgentUser->id.'" title="حذف" class="btn-create2   delete-user addContent"><i class="fa fa-minus"></i></span>
                                                </div>
                                            </div>';
                    }
                }
            }
        }
        return json_encode($result);

    }
    public function actionDeleteUserAjax()
    {

        $result['msg']= Yii::t('app', 'Error occurred during user deleting!');
        $result['result']=0;
        $post=Yii::$app->request->post();
        if(isset($post['userAgentId']) && $post['userAgentId']) $id=$post['userAgentId'];
        if($id && ($model = $this->findModel($id))) {
            if ($model->logicalDelete()) {
                $result['msg'] =  Yii::t('app', 'User has been successfully deleted!');
                $result['result']=1;
            }

        }
        return json_encode($result);

    }
    public function actionInsert_user_block(){
        $data=Yii::$app->request->get();
        if(isset($data)){
            if(isset($data['id']))
                $id = (int)$data['id'];
            else
                return 0;
            if(isset($data['agent']))
                $agent = (int)$data['agent'];
            else
                $agent=0;
        }
        $id++;
        $models_user=new AgentUserLogic();
        $html='<div class="row parent_of_dropdown"><div class="col-6"><div class="form-group field-agentlogic-user_id has-success">';
        $html.='<select id="'.$id.'" class="form-control users_list" name="AgentLogic[users]['.$id.']" aria-invalid="false">';
        $html.='<option></option>';
        if($agent){
            $model_user_for_agent=$models_user->get_user_for_agent_update($agent);
        }else{
            $model_user_for_agent=$models_user->get_user_for_agent();
        }
        if($model_user_for_agent) {
            foreach ($model_user_for_agent as $model_user) {
                $html.="<option value='$model_user->id'>$model_user->name</option>";
            }
        }
        $html.='</select>';
        $html.='<div class="help-block"></div>';
        $html.='</div></div>';
        $html.='<div class="col-2 parent_of_btn"><span class="btn-create2 removeContent" ><i class="fa fa-minus"></i></span></div></div>';
        return $html;
    }

}
