<?php

namespace backend\modules\gas_liquid\controllers;

use backend\modules\gas_liquid\models\logic\AgentLogic;
use backend\modules\gas_liquid\models\logic\AgentUserLogic;
use backend\modules\user\models\RoleLogic;
use backend\modules\user\models\UserLogic;
use Yii;
use backend\modules\gas_liquid\models\activeRecord\Agent;
use backend\modules\gas_liquid\models\search\AgentSearch;
use yii\filters\AccessControl;
use yii\helpers\ArrayHelper;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * AgentPanelController implements the CRUD actions for Agent model.
 */
class AgentPanelController extends \common\controllers\BaseController
{
    public $layout='agent';

    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['index'],
                        'roles' => [RoleLogic::PERMISSION_OWN_PANEl_AGENT],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];

    }

    /**
     * Lists all Agent models.
     * @return mixed
     */
    public function actionIndex($id=false)
    {
        if (Yii::$app->user->identity->role=='agent') {
            $this->layout = 'agent';
            $adminMode=false;
        }
        else  if (Yii::$app->user->identity->role=='admin'){
            $agent_id=$id;
            $adminMode=true;
        }
        $model=New AgentLogic();
        $model_agent_user=New AgentUserLogic();
        //----------------------------check customer-----------------------------------
        if ((!isset($agent_id)) && (!$agent_id = $model_agent_user->get_agent_Of_currentUser()))
            Yii::$app->getSession()->setFlash('fatal', Yii::t('app', 'You do not have any active agent'));
        else {
            $model=$this->findModel($agent_id);
        }
        return $this->render('index', [
            'model' => $model,
        ]);
    }


    /**
     * Finds the Agent model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Agent the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = AgentLogic::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


}
