<?php

namespace backend\modules\gas_liquid\controllers;

use backend\models\logic\CustomerLogic;
use backend\models\logic\IdentityLogic;
use backend\modules\contract\models\logic\CustomerAttributesLogic;
use backend\modules\gas_liquid\models\activeRecord\Agent;
use backend\modules\gas_liquid\models\form\MessageForm;
use backend\modules\gas_liquid\models\logic\AgentLogic;
use backend\modules\gas_liquid\models\logic\AgentUserLogic;
use backend\modules\gas_liquid\models\logic\FactoryAgentsLogic;
use backend\modules\gas_liquid\models\search\AgentSearch;
use backend\modules\user\models\RoleLogic;
use backend\modules\user\models\UserLogic;
use Yii;
use yii\filters\AccessControl;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;
use yii\web\NotFoundHttpException;

/**
 * AgentController implements the CRUD actions for Agent model.
 */
class AgentController extends \common\controllers\BaseController
{
    public $layout='gasLiquid';
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['index','list'],
                        'roles' => [RoleLogic::PERMISSION_LIST_FACTORY],
                    ],
                    [
                        'allow' => true,
                        'actions' => ['create','create-ajax'],
                        'roles' => [RoleLogic::PERMISSION_CREATE_FACTORY],
                    ],
                    [
                        'allow' => true,
                        'actions' => ['update'],
                        'roles' => [RoleLogic::PERMISSION_UPDATE_FACTORY],
                    ],
                    [
                        'allow' => true,
                        'actions' => ['delete'],
                        'roles' => [RoleLogic::PERMISSION_DELETE_FACTORY],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];

    }

    /**
     * Lists all Agent models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new AgentSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }
    /**
     * Lists all Agent models.
     * @return mixed
     */
    public function actionList()
    {
        $searchModel = new AgentSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $messageForm=New MessageForm();

        return $this->render('list', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'messageForm'=>$messageForm,

        ]);
    }
    /**
     * Displays a single Agent model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Agent model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new AgentLogic();
        $modelCustomer=New CustomerLogic();
        $modelIdentity=New IdentityLogic();
        $customerType=CustomerLogic::LiquidGasAgent;
        if ($model->load(Yii::$app->request->post()) ) {
            $modelIdentity->name=$model->name;

            $modelCustomer->name = $model->name;
            $modelCustomer->manager_name = $model->name;
            $modelCustomer->city_id = ($model->city_id)?$model->city_id:Yii::$app->params['city_id'];
            $modelCustomer->status = ($model->status)?$model->status:CustomerLogic::Active;
            $modelCustomer->manager_mobile = $model->mobile;
            $modelCustomer->address = $model->address;
            $modelCustomer->type = $customerType;
            if ($modelCustomer->save() && $modelIdentity->save()) {
                $model->customer_id = $modelCustomer->id;
                $model->identity_id = $modelIdentity->id;
                if ($model->save()) {
                    Yii::$app->getSession()->setFlash('success', Yii::t('app', 'Agent successfully registered'));
                    return $this->redirect(['update', 'id' => $model->id]);
                } else
                    Yii::$app->getSession()->setFlash('error', Yii::t('app', 'Unfortunately, an error occurred while registering the agent. Please try again.'));
            }else
                Yii::$app->getSession()->setFlash('error', Yii::t('app', 'Unfortunately, an error occurred while registering the agent. Please try again.'));

        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Agent model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {

        $model = $this->findModel($id);
        $model_agent_user=new AgentUserLogic();
        $modeFactoryAgent=new FactoryAgentsLogic();
        $modelCustomer = $this->findModelCustomer($model->customer_id);
        $model->loadCustomerInfo($modelCustomer);
        $modeIdentity = $this->findModelIdentity($model->identity_id);

        $result=true;
        if($users=$model_agent_user->get_users_of_agent($model->id))
            $user_array = ArrayHelper::map($users, 'id', 'id');


        if($post=Yii::$app->request->post()) {
            if (isset($post['FactoryAgentsLogic'])) {
                $modeFactoryAgent->load($post);
                $modeFactoryAgent->status=FactoryAgentsLogic::Active;
                if ($modeFactoryAgent->save()){
                    $modeFactoryAgent->changeOtherStatus();
                    Yii::$app->getSession()->setFlash('success', Yii::t('app', 'Agent successfully registered'));
                }
                else
                    Yii::$app->getSession()->setFlash('error', Yii::t('app', 'Unfortunately, an error occurred while registering the agent. Please try again.'));
            }
            if (isset($post['IdentityLogic'])) {
                $modeIdentity->load($post);
                if ($modeIdentity->save())
                    Yii::$app->getSession()->setFlash('success', Yii::t('app', 'Agent successfully registered'));
                else
                    Yii::$app->getSession()->setFlash('error', Yii::t('app', 'Unfortunately, an error occurred while registering the agent. Please try again.'));
            }
            if (isset($post['IdentityLogic'])) {
                if ($model->load($post) && $result = $model->save()) {
                    $modelCustomer->name = $model->name;
                    $modelCustomer->manager_name = $model->name;
                    $modelCustomer->city_id = ($model->city_id) ? $model->city_id : Yii::$app->params['city_id'];
                    $modelCustomer->status = ($model->status) ? $model->status : CustomerLogic::Active;
                    $modelCustomer->manager_mobile = $model->mobile;
                    $modelCustomer->address = $model->address;
                    $result = $modelCustomer->save();
                    if ($model->users) {
                        foreach ($model->users as $user) {
                            if ($user && (!in_array($user, $user_array))) {
                                $model_user = new AgentUserLogic();
                                $model_user->agent_id = $model->id;
                                $model_user->user_id = $user;
                                if (!$model_user->save()) $result = false;
                            }
                        }
                    }
                }
                if ($result)
                    Yii::$app->getSession()->setFlash('success', Yii::t('app', 'Agent successfully registered'));
                else
                    Yii::$app->getSession()->setFlash('error', Yii::t('app', 'Unfortunately, an error occurred while registering the agent. Please try again.'));

            }
        }

        $modelUserNew=New UserLogic();
        $factoryRegions=FactoryAgentsLogic::getAll($id);
        $contractsList=CustomerAttributesLogic::getAll($model->customer_id);

        return $this->render('update', [
            'model' => $model,
            'modelUserNew'=>$modelUserNew,
            'users'=>$users,
            'modeIdentity'=>$modeIdentity,
            'factoryRegions'=>$factoryRegions,
            'modeFactoryAgentNew'=>$modeFactoryAgent,
            'contractsList'=>$contractsList,
        ]);
    }

    /**
     * Deletes an existing Agent model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        if($this->findModel($id)->logicalDelete())
            Yii::$app->getSession()->setFlash('success', Yii::t('app', 'Agent successfully deleted'));
        else
            Yii::$app->getSession()->setFlash('error', Yii::t('app', 'Unfortunately, an error occurred while deleting the agent. Please try again.'));

        return $this->redirect(['index']);
    }

    /**
     * Finds the Agent model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Agent the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = AgentLogic::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    public function actionCreateAjax()
    {
        $model = new AgentLogic();
        $modelCustomer=New CustomerLogic();
        $result['msg']= Yii::t('app', 'Error occurred during agent creating');
        $result['result']=0;
        $post=Yii::$app->request->post();
        if (isset($post['factoryId']) && $post['factoryId']){
            $factoryId=$post['factoryId'];
        }
        foreach ($post['data'] as $index=>$content){
            $fieldName=substr($content['name'],strpos($content['name'],'[')+1 ,strpos($content['name'],']')-strpos($content['name'],'[')-1);
            $data['AgentLogic'][$fieldName]=$content['value'];
        }
        if(isset($data)) {
            if ($model->load($data)) {
                $modelCustomer->name = $model->name;
                $modelCustomer->manager_name = $model->name;
                $modelCustomer->city_id =  Yii::$app->params['city_id'];
                $modelCustomer->status = ($model->status) ? $model->status : CustomerLogic::Active;
                $modelCustomer->type =CustomerLogic::LiquidGasAgent;
                if($modelCustomer->save()) {
                    $model->customer_id = $modelCustomer->id;
                    $model->type = 1;
                    if ($model->save()) {
                        $result['result'] = 1;
                        $result['msg'] = Yii::t('app', 'Agent has been successfully submitted');
                        $result['data']='<option value="'.$model->id.'" selected="selected">'.$model->name.'</option>';
                    }
                }
            }
        }
        return json_encode($result);

    }
    /**
     * Finds the Customer model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return CustomerLogic the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModelCustomer($id)
    {
        if (($model = CustomerLogic::findOne($id)) !== null) {
            return $model;
        }
        return New CustomerLogic();

    }
    /**
     * Finds the Identity model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return \backend\models\logic\IdentityLogic the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModelIdentity($id)
    {
        if (($model = IdentityLogic::findOne($id)) !== null) {
            return $model;
        }
        return New IdentityLogic();
    }
}
